// LunchTimeCoder.ServiceMonitor
// Copyright (c) 2007 Chris Pietschmann (http://pietschsoft.com)
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace LunchTimeCoder.ServiceMonitor
{
    public partial class frmServicePicker : Form
    {
        public frmServicePicker()
        {
            InitializeComponent();
        }

        private void frmServicePicker_Load(object sender, EventArgs e)
        {
            lbServices.DoubleClick += new EventHandler(lbServices_DoubleClick);
            //Lets load the Services list asynchronously when the form loads
            Timer t = new Timer();
            t.Interval = 1;
            t.Tick += new EventHandler(t_Tick);
            t.Start();
        }

        void lbServices_DoubleClick(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.OK;
        }

        void t_Tick(object sender, EventArgs e)
        {
            //Stop the timer because we only want it to run once
            if (sender != null) ((Timer)sender).Stop();

            
            // Load the services list and show progress along the way
            lbServices.Enabled = false;
            lbServices.Items.Clear();
            ShowServiceCount(0);
            progressLoading.Minimum = 1; progressLoading.Maximum = 100; progressLoading.Value = 1;
            lblLoading.Visible = true;
            progressLoading.Visible = true;

            System.ServiceProcess.ServiceController controller;
            ServiceInfo si;
            System.ServiceProcess.ServiceController[] services;

            string strComputer = txtComputer.Text;
            if (strComputer.Length == 0)
                services = System.ServiceProcess.ServiceController.GetServices();
            else
                try
                {
                    services = System.ServiceProcess.ServiceController.GetServices(strComputer);
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.Message, "Error Listing Services");
                    return;
                }

            progressLoading.Minimum = 1;
            progressLoading.Maximum = services.Length + 1;
            progressLoading.Value = progressLoading.Minimum;

            for (int i = 0; i < services.Length; i++)
            {
                controller = services[i];
                si = new ServiceInfo();
                si.DisplayName = controller.DisplayName;
                si.ServiceName = controller.ServiceName;
                si.ListName = si.DisplayName + " (" + controller.Status.ToString() + ")";
                si.Computer = strComputer;
                lbServices.Items.Add(si);
                progressLoading.Value++;
                Application.DoEvents();
            }

            lbServices.SelectedIndex = 0;

            ShowServiceCount(services.Length);
            progressLoading.Visible = false;
            lbServices.Enabled = true;
        }

        private void ShowServiceCount(int c)
        {
            lblLoading.Text = c.ToString() + " Services Listed";
        }

        public ServiceInfo SelectedService
        {
            get
            {
                return this.lbServices.SelectedItem as ServiceInfo;
            }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            t_Tick(null, new EventArgs());
        }

    }
}